<?php

namespace Modules\Subscription\Http\Controllers;

use App\Http\Controllers\Controller;
use Flasher\Laravel\Http\Request;
use Illuminate\Support\Facades\View;
use LDAP\Result;
use Modules\Subscription\Repositories\Subscription\SubscriptionRepository;
use Modules\Subscription\Services\SubscriptionService;

class SubscriptionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function apply($slug)
    {
        $type  = Request()->get('type') ??  'course';
        if (!authCheck()) {
            return redirect()->route('login');
        }
        $response = SubscriptionService::applySubscription($slug,  $type);

        if ($response['status'] == 'error') {
            toastr()->error($response['message']);
        } else {
            toastr()->success($response['message']);
        }
        return redirect()->back();
    }


    /**
     * Method subscriptionList
     *
     * @return View
     */
    public function subscriptionList()
    {
        $response =  SubscriptionRepository::get(options: ['where' =>  ['status', 1]]);
        $subscriptions = $response['data'] ?? [];
        $data = [
            'subscriptions' => $subscriptions,
            'activePlan' => SubscriptionService::getActiveSubscription(),
            'dayOfUse' => SubscriptionService::getDayOfUse(),
        ];
        return view('portal::student.subscription.index', $data);
    }
}
