@php
    $subscription = $subscription ?? null;
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    if ($subscription && $locale) {
        $translations = parse_translation($subscription, $locale);
    }
    $title = $translations['title'] ?? ($subscription->title ?? '');
    $description = $translations['description'] ?? ($subscription->description ?? '');
@endphp

<x-dashboard-layout>
    <x-slot:title>{{ isset($subscription) ? translate('Edit') : translate('Create') }} {{ translate('Subscription') }}
    </x-slot:title>
    <!-- BREADCRUMB -->
    <x-portal::admin.breadcrumb back-url="{{ route('subscription.index') }}"
        title="{{ isset($subscription) ? 'Edit' : 'Create' }}" page-to="Subscription" />
    @if (is_active('subscription.translate') === 'active')
        <div class="flex items-center justify-end gap-4 mb-2">
            <h2 class="card-title">{{ translate('Translate Language') }}</h2>
            <form method="GET" class="sm:block" id="change-translate-language">
                <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                    class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                    @foreach (app('languages') as $lang)
                        <option value="{{ $lang->code }}" {{ $locale == $lang->code ? 'selected' : '' }}>
                            {{ $lang->name }}
                        </option>
                    @endforeach
                </select>
            </form>
        </div>
    @endif
    <form action="{{ isset($subscription) ? route('subscription.update', $subscription->id) : route('subscription.store') }}"
        method="post" class="form mb-4" enctype="multipart/form-data">
        @csrf
        @if (isset($subscription))
            @method('PUT')
            <input type="hidden" name="locale" class="form-input" value="{{ $locale ?? '' }}">
        @endif
        <div class="grid grid-cols-12 gap-x-4">
            <div class="grid grid-cols-12 gap-4 col-span-full lg:col-span-8 card">
                <div class="col-span-full md:col-span-6">
                    <label class="form-label">
                        {{ translate('Title') }}
                        <span class="text-danger" title="{{ translate('This field is required') }}"><b>*</b></span>
                    </label>
                    <input type="text" name="title" value="{{ $title }}" class="form-input">
                    <span class="text-danger error-text title_err"></span>
                </div>

                <div class="col-span-full md:col-span-6">
                    <label class="form-label">
                        {{ translate('Description') }}
                        <span class="text-danger" title="{{ translate('This field is required') }}"><b>*</b></span>
                    </label>
                    <input type="text" name="description" value="{{ $description }}" class="form-input">
                    <span class="text-danger error-text description_err"></span>
                </div>

                @if (is_active('subscription.edit') === 'active' || is_active('subscription.create') === 'active')
                    <div class="col-span-full md:col-span-6">
                        <label for="usableCount" class="form-label">
                            {{ translate('Usable Count') }}
                            <span class="text-danger" title="{{ translate('This field is required') }}"><b>*</b></span>
                        </label>
                        <input type="text" id="usableCount" name="usable_count"
                            value="{{ $subscription->usable_count ?? '' }}" class="form-input">
                        <span class="text-danger error-text usable_count_err"></span>
                    </div>
                    <div class="col-span-full md:col-span-6">
                        <label class="form-label">
                            {{ translate('Days') }}
                            <span class="text-danger" title="{{ translate('Days field is required') }}"><b>*</b></span>
                        </label>
                        <input type="text" name="days" value="{{ $subscription->days ?? '' }}" class="form-input">
                        <span class="text-danger error-text title_err"></span>
                    </div>

                    <div class="col-span-full md:col-span-6">
                        <label class="form-label">
                            {{ translate('Price') }}
                            <span class="text-danger" title="{{ translate('This field is required') }}"><b>*</b></span>
                        </label>
                        <input type="number" name="price" value="{{ $subscription->price ?? '' }}" class="form-input">
                        <span class="text-danger error-text price_err"></span>
                    </div>
                    <div class="col-span-full leading-none">
                        <label class="form-label">
                            {{ translate('Is Popular') }}
                            <span class="text-danger"></span>
                        </label>
                        <div class="form-check form-switch">
                            <label class="inline-flex items-center me-5 cursor-pointer">
                                <input type="checkbox" class="hidden appearance-none peer"
                                    {{ isset($subscription) && $subscription->is_popular ? 'checked' : '' }}
                                    name="is_popular">
                                <span class="switcher switcher-primary-solid"></span>
                            </label>
                        </div>
                    </div>
                @endif
            </div>
            @if (is_active('subscription.edit') === 'active' || is_active('subscription.create') === 'active')
                <div class="col-span-full lg:col-span-4 card">
                    <label class="form-label">
                        {{ translate('Icon Image') }} (70x70)
                    </label>
                    <label for="image"
                        class="dropzone-wrappe mb-4 file-container ac-bg text-xs leading-none font-semibold cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10">
                        <input type="file" hidden name="image" id="image"
                            class="dropzone dropzone-image img-src peer/file">
                        <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                            <img src="{{ asset('lms/assets/images/icons/upload-file.svg') }}" alt="file-icon"
                                class="size-8 lg:size-auto">
                            <div class="text-gray-500 dark:text-dark-text mt-2"> {{ translate('Choose file') }} </div>
                        </span>
                        <span class="text-danger error-text image_err"></span>
                    </label>
                    <div class="preview-zone dropzone-preview">
                        <div class="box box-solid">
                            <div class="box-body flex items-center gap-2 flex-wrap">
                                @if (isset($subscription) && fileExists('lms/subscriptions', $subscription->icon_img) == true && $subscription->icon_img !== '')
                                    <div class="img-thumb-wrapper">
                                        <img class="img-thumb"
                                            src="{{ asset('storage/lms/subscriptions/' . $subscription->icon_img) }}"
                                            alt="">
                                    </div>
                                @else
                                    <div class="img-thumb-wrapper max-w-[120px] max-h-[120px]">
                                        <button class="remove text-danger">
                                            <i class="ri-close-line text-inherit text-[13px]"></i>
                                        </button>
                                        <img id="preview_img" width="auto" height="auto">
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            <div class="col-span-full card flex justify-end">
                <button type="submit" class="btn b-solid btn-primary-solid w-max dk-theme-card-square">
                    {{ isset($subscription) ? translate('Update') : translate('Save') }}
                </button>
            </div>
        </div>
    </form>
</x-dashboard-layout>
