<?php

use Illuminate\Support\Facades\Route;
use Modules\Subscription\Http\Controllers\SubscriptionController;
use Modules\Subscription\Http\Controllers\Admin\SubscriptionController as AdminSubscriptionController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(
    ['prefix' => 'admin', 'middleware' => ['auth:admin']],
    function () {
        Route::resource('subscription', AdminSubscriptionController::class);
        Route::get('status-change/{id}', [AdminSubscriptionController::class, 'statusChange'])->name('subscription.status');
        Route::put('subscription/restore/{id}', [AdminSubscriptionController::class, 'restore'])->name('subscription.restore');
        Route::get('subscription/{id}/translate/{locale}', [AdminSubscriptionController::class, 'edit'])->name('subscription.translate');
    });

Route::group(
    ['prefix' => 'dashboard', 'as' => 'student.', 'middleware' => ['auth', 'role:Student', 'checkInstaller']],
    function () {
        Route::group(['controller' => SubscriptionController::class], function () {
            Route::get('subscriptions', 'subscriptionList')->name('subscription.list');
        });
    }
);

Route::group(['prefix' => 'subscription', 'controller' => SubscriptionController::class], function () {
    Route::get('apply/{slug}', 'apply')->name('subscription.apply');
});
